<?php

namespace Clonable\Translator\Api\Service;

interface ClonableGetSiteInfoApiInterface
{
    /**
     * @param null $apiKey
     * @param null $storeId
     */
    public function getSiteInfo($apiKey = null, $storeId = null);

    /**
     * @param $siteInfo
     */
    public function getSiteId($siteInfo);

    /**
     * @param $siteInfo
     */
    public function getOriginLanguage($siteInfo);

    /**
     * @param $siteInfo
     * @param $storeCode
     */
    public function getTargetLanguage($siteInfo, $storeCode);

    /**
     * @param $siteInfo
     * @param $storeCode
     */
    public function getCloneId($siteInfo, $storeCode);
}
