<?php

namespace Clonable\Translator\Model\Product\Condition;

use Clonable\Translator\Model\ConfigManager;
use Magento\Catalog\Api\Data\ProductInterface;

class ConfigEnabledAutoTranslate
{
    private ConfigManager $configManager;

    public function __construct(
        ConfigManager $configManager,
    ) {
        $this->configManager = $configManager;
    }

    public function handle(ProductInterface $product): bool
    {
        if ($this->configManager->isEnabledAutoTranslation($product->getStoreId())) {
            return true;
        }
        return false;
    }
}
