<?php

namespace Clonable\Translator\Model\Service;

use Magento\Framework\Exception\LocalizedException;
use Magento\Store\Model\StoreManagerInterface;
use Clonable\Translator\Model\Service\ClonableGetSiteInfoApi;
use Clonable\Translator\Model\ConfigManager;
use Clonable\Translator\Model\Logger\Logger;

class UpdateSiteInfoService
{
    private ClonableGetSiteInfoApi $clonableGetSiteInfoApi;
    private ConfigManager $configManager;
    private StoreManagerInterface $storeManager;

    private Logger $logger;

    public function __construct
    (
        ConfigManager $configManager,
        ClonableGetSiteInfoApi $clonableGetSiteInfoApi,
        StoreManagerInterface $storeManager,
        Logger $logger
    ){
        $this->configManager = $configManager;
        $this->clonableGetSiteInfoApi = $clonableGetSiteInfoApi;
        $this->storeManager = $storeManager;
        $this->logger = $logger;
    }

    /**
     * @throws LocalizedException
     */
    public function updateSiteInfo($apikey, $storeId)
    {
        try {
            $store = $this->storeManager->getStore($storeId);
            $siteInfo = $this->clonableGetSiteInfoApi->getSiteInfo($apikey, $storeId);
            $this->updateConfigSiteInfo($siteInfo, $store);
        } catch (LocalizedException $e) {
            throw new LocalizedException(__($e->getMessage()));
        }
    }

    private function updateConfigSiteInfo($siteInfo, $store)
    {
        $storeCode = $store->getCode();
        $storeId = $store->getId();
        $this->configManager->setSiteId($this->clonableGetSiteInfoApi->getSiteId($siteInfo), $storeId);
        $this->configManager->setOriginalLanguage($this->clonableGetSiteInfoApi->getOriginLanguage($siteInfo), $storeId);
        $this->configManager->setTargetLanguage($this->clonableGetSiteInfoApi->getTargetLanguage($siteInfo, $storeCode), $storeId);
        $this->configManager->setCloneId($this->clonableGetSiteInfoApi->getCloneId($siteInfo, $storeCode), $storeId);
        $this->configManager->setSubfolderClone($this->clonableGetSiteInfoApi->getSubfolderClone($siteInfo, $storeCode), $storeId);
    }
}
