<?php

namespace Clonable\Translator\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\MessageQueue\PublisherInterface;
use Clonable\Translator\Model\ConfigManager;

/**
 * Observes the `catalog_category_save_after` event.
 */
class CategoryAfterSaveObserver implements ObserverInterface
{
    private PublisherInterface $publisher;
    private ConfigManager $configManager;
    public function __construct
    (
        PublisherInterface $publisher,
        ConfigManager $configManager
    ){
        $this->publisher = $publisher;
        $this->configManager = $configManager;
    }

    /**
     * Observer for catalog_product_save_after.
     *
     * @param Observer $observer
     *
     * @return void
     */
    public function execute(Observer $observer): void
    {
        if ($this->configManager->isEnabled()) {
            $category = $observer->getEvent()->getCategory();
            if (!$category->getExcludeClonableAutotranslation()) {
                $message [] = ['category_id' => $category->getId()];
                $this->publisher->publish($this->configManager->getTopicQueueForCategory(), $message);
            }
        }
    }
}
