<?php

namespace Clonable\Translator\Api\Service;

interface ClonableGetSiteInfoApiInterface
{
    /**
     * @param null $apiKey
     * @param null $storeId
     */
    public function getSiteInfo($apiKey = null, $storeId = null);

    /**
     * @param $siteInfo
     */
    public function getSiteId($siteInfo);

    /**
     * @param $siteInfo
     */
    public function getOriginLanguage($siteInfo);

    /**
     * @param mixed $siteInfo
     * @param string $storeCode
     * @param string $baseUrl
     */
    public function getTargetLanguage($siteInfo, string $storeCode, string $baseUrl);

    /**
     * @param mixed $siteInfo
     * @param string $storeCode
     * @param string $baseUrl
     */
    public function getCloneId($siteInfo, string $storeCode, string $baseUrl);

    /**
     * @param $siteInfo
     * @param string $storeCode
     * @param string $baseUrl
     * @return string|null
     */
    public function getSubfolderClone($siteInfo, string $storeCode, string $baseUrl): ?string;
}
