<?php

namespace Clonable\Translator\Controller\Adminhtml\Report;

use Clonable\Translator\Api\ReportLogsRepositoryInterface;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\Result\Redirect;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Exception\LocalizedException;

class MassDelete extends Action
{
    private ReportLogsRepositoryInterface $reportLogsRepository;

    public function __construct(
        Context $context,
        ReportLogsRepositoryInterface $reportLogsRepository
    ) {
        parent::__construct($context);
        $this->reportLogsRepository = $reportLogsRepository;
    }

    public function execute()
    {
        $ids = $this->getRequest()->getParam('selected', []);
        if (!is_array($ids) || empty($ids)) {
            $this->messageManager->addErrorMessage(__('Please select items to delete.'));
        } else {
            try {
                foreach ($ids as $id) {
                    $this->reportLogsRepository->deleteById($id);
                }
                $this->messageManager->addSuccessMessage(__('A total of %1 record(s) have been deleted.', count($ids)));
            } catch (LocalizedException $e) {
                $this->messageManager->addErrorMessage($e->getMessage());
            } catch (\Exception $e) {
                $this->messageManager->addErrorMessage(__('An error occurred while deleting records.'));
            }
        }

        /** @var Redirect $resultRedirect */
        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        return $resultRedirect->setPath('*/*/index');
    }
}
