<?php

namespace Clonable\Translator\Model\Queue\Consumer;

use Clonable\Translator\Model\Cms\TranslatorCms;
use Magento\Framework\MessageQueue\ConsumerConfigurationInterface;
use Magento\Framework\MessageQueue\ConsumerInterface;

class Cms implements ConsumerInterface
{
    private TranslatorCms $translatorCms;
    private ConsumerConfigurationInterface $configuration;

    public function __construct
    (
        ConsumerConfigurationInterface $configuration,
        TranslatorCms $translatorCms
    ){
        $this->configuration = $configuration;
        $this->translatorCms = $translatorCms;
    }

    public function process($maxNumberOfMessages = null)
    {
        $queue = $this->configuration->getQueue();
        $this->translatorCms->processMessage($queue);
    }
}

