<?php

namespace Clonable\Translator\Model\Queue\Consumer;

use Clonable\Translator\Model\Category\TranslatorCategory;
use Magento\Framework\MessageQueue\ConsumerConfigurationInterface;
use Magento\Framework\MessageQueue\ConsumerInterface;

class Category implements ConsumerInterface
{
    private TranslatorCategory $translatorCategory;
    private ConsumerConfigurationInterface $configuration;

    public function __construct
    (
        ConsumerConfigurationInterface $configuration,
        TranslatorCategory $translatorCategory
    ){
        $this->configuration = $configuration;
        $this->translatorCategory = $translatorCategory;
    }

    public function process($maxNumberOfMessages = null)
    {
        $queue = $this->configuration->getQueue();
        $this->translatorCategory->processMessage($queue);
    }
}
