<?php

namespace Clonable\Translator\Observer;

use Clonable\Translator\Model\Product\Condition\ConditionChain;
use Clonable\Translator\Model\Service\Product\ProcessAssociatedProducts;
use Exception;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Exception\NoSuchEntityException;


class AfterImportProductsObserver implements ObserverInterface {
    private ProductRepositoryInterface $productRepository;

    private ConditionChain $conditionChain;

    private ProcessAssociatedProducts $processAssociatedProducts;

    public function __construct(
        ProductRepositoryInterface $productRepository,
        ConditionChain            $conditionChain,
        ProcessAssociatedProducts $processAssociatedProducts
    ) {
        $this->productRepository = $productRepository;
        $this->conditionChain = $conditionChain;
        $this->processAssociatedProducts = $processAssociatedProducts;
    }

    /**
     * @throws Exception
     */
    public function execute(Observer $observer): void {
        $bunch = $observer->getEvent()->getBunch();

        foreach ($bunch as $productData) {
            if (isset($productData['sku'])) {
                try {
                    $product = $this->productRepository->get($productData['sku']);
                    if ($product->getStore()->isDefault()) {
                        foreach ($product->getStoreIds() as $storeId) {
                            try {
                                $productByStore = $this->productRepository->get($product->getSku(), false, $storeId, true);
                                $this->conditionChain->process($productByStore);
                                $this->processAssociatedProducts->processAssociatedProducts($productByStore);
                            } catch (NoSuchEntityException $e) {
                                continue;
                            }
                        }
                    }
                } catch (Exception $e) {
                    throw new Exception($e->getMessage());
                }
            }
        }
    }
}
