<?php

namespace Clonable\Translator\Controller\Adminhtml\Category;

use Clonable\Translator\Model\Logger\Logger;
use Clonable\Translator\Model\Category\Condition\ConditionChain;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Catalog\Api\CategoryRepositoryInterface;
use Magento\Catalog\Api\Data\CategoryInterface;
use Magento\Catalog\Helper\Category as CategoryHelper;
use Magento\Catalog\Model\CategoryRepository;
use Magento\Catalog\Model\ResourceModel\Category\Collection;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Store\Model\StoreManagerInterface;

class TranslateCategories extends Action
{
    private Logger $logger;
    private CategoryHelper $categoryHelper;
    private CategoryRepository $categoryRepository;
    private ConditionChain $conditionChain;
    private StoreManagerInterface $storeManager;

    public function __construct(
        Context $context,
        Logger $logger,
        CategoryHelper $categoryHelper,
        CategoryRepositoryInterface $categoryRepository,
        ConditionChain $conditionChain,
        StoreManagerInterface $storeManager
    )
    {
        parent::__construct($context);
        $this->logger = $logger;
        $this->categoryHelper = $categoryHelper;
        $this->categoryRepository = $categoryRepository;
        $this->conditionChain = $conditionChain;
        $this->storeManager = $storeManager;
    }

    /**
     * @inheritDoc
     */
    public function execute()
    {
        /** @var Collection $categories */
        $categories = $this->categoryHelper->getStoreCategories(false, true);
        foreach ($categories as $category) {
            /** @var CategoryInterface $category */
            try {
                if ($category->getStore()->isDefault()) {
                    foreach ($category->getStoreIds() as $storeId) {
                        try {
                            $categoryByStore = $this->categoryRepository->get($category->getId(), $storeId);
                            $this->conditionChain->process($categoryByStore);
                        } catch (NoSuchEntityException $e) {
                            continue;
                        }
                    }
                }
            } catch (NoSuchEntityException $e) {
                $this->logger->error($e->getMessage());
                continue;
            }
        }
    }
}