<?php

namespace Clonable\Translator\Model\Category\Condition;

use Clonable\Translator\Model\ConfigManager;
use Magento\Catalog\Api\Data\CategoryInterface;

class ConfigEnabledAutoTranslate
{
    private ConfigManager $configManager;

    public function __construct(
        ConfigManager $configManager
    ) {
        $this->configManager = $configManager;
    }

    public function handle(CategoryInterface $category): bool
    {
        if ($this->configManager->isEnabledCategoryAutoTranslation($category->getStoreId())) {
            return true;
        }
        return false;
    }
}
