<?php

namespace Clonable\Translator\Observer;

use Clonable\Translator\Model\Category\Condition\ConditionChain;
use Magento\Catalog\Api\CategoryRepositoryInterface;
use Magento\Catalog\Api\Data\CategoryInterface;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\Exception\NoSuchEntityException;

/**
 * Observes the `catalog_category_save_after` event.
 */
class CategoryAfterSaveObserver implements ObserverInterface
{
    private ConditionChain $conditionChain;


    private CategoryRepositoryInterface $categoryRepository;

    public function __construct
    (
        ConditionChain             $conditionChain,
        CategoryRepositoryInterface $categoryRepository
    ) {
        $this->conditionChain = $conditionChain;
        $this->categoryRepository = $categoryRepository;
    }
    /**
     * Observer for catalog_product_save_after.
     *
     * @param Observer $observer
     *
     * @return void
     */
    public function execute(Observer $observer): void
    {
        /** @var CategoryInterface $category */
        $category = $observer->getCategory();
        foreach ($category->getStoreIds() as $storeId) {
            try {
                $categoryByStore = $this->categoryRepository->get($category->getId(), $storeId);
                $this->conditionChain->process($categoryByStore);
            } catch (NoSuchEntityException $e) {
                continue;
            }
        }
    }
}
