<?php

namespace Clonable\Translator\Controller\Adminhtml\Report;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Clonable\Translator\Api\ReportLogsRepositoryInterface;
use Magento\Framework\Controller\Result\RedirectFactory;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\Controller\ResultFactory;

class Clear extends Action
{
    protected ReportLogsRepositoryInterface $reportLogsRepository;

    /**
     * @var ResourceConnection
     */
    protected $resourceConnection;

    public function __construct(
        Context $context,
        ReportLogsRepositoryInterface $reportLogsRepository,
        RedirectFactory $resultRedirectFactory,
        ResourceConnection $resourceConnection
    ) {
        parent::__construct($context);
        $this->reportLogsRepository = $reportLogsRepository;
        $this->resultRedirectFactory = $resultRedirectFactory;
        $this->resourceConnection = $resourceConnection;
    }

    public function execute()
    {
        try {
            $connection = $this->resourceConnection->getConnection();
            $connection->truncateTable($connection->getTableName('cln_report_logs'));
            $this->messageManager->addSuccessMessage(__('Logs have been successfully cleared from the database.'));
        } catch (\Exception $e) {
            $this->messageManager->addErrorMessage(__('Error clearing logs from the database: ' . $e->getMessage()));
        }
        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        return $resultRedirect->setPath('*/*/');
    }
}
