<?php

namespace Clonable\Translator\Model\Queue\Consumer;

use Clonable\Translator\Model\Category\TranslatorCategory;
use Magento\Framework\MessageQueue\ConsumerConfigurationInterface;
use Magento\Framework\MessageQueue\ConsumerInterface;

class Category implements ConsumerInterface
{
    private TranslatorCategory $translatorCategory;
    private ConsumerConfigurationInterface $configuration;

    public function __construct
    (
        ConsumerConfigurationInterface $configuration,
        TranslatorCategory $translatorCategory
    ){
        $this->configuration = $configuration;
        $this->translatorCategory = $translatorCategory;
    }

    /**
     * @param null $maxNumberOfMessages
     */
    public function process($maxNumberOfMessages = null): void
    {
        $queue = $this->configuration->getQueue();
        $this->translatorCategory->processMessage($queue);
        if (!isset($maxNumberOfMessages)) {
            $this->runDaemonMode($queue);
        } else {
            $this->run($queue, $maxNumberOfMessages);
        }
    }

    private function runDaemonMode($queue): void
    {
        while (true) {
            $this->translatorCategory->processMessage($queue);
        }
    }

    private function run($queue, $maxNumberOfMessages): void
    {
        for ($i = 1; $i < $maxNumberOfMessages; $i++) {
            $this->translatorCategory->processMessage($queue);
        }
    }
}
