<?php
namespace Clonable\Translator\Controller\Adminhtml\Product;

use Clonable\Translator\Model\ConfigManager;
use Clonable\Translator\Model\Logger\Logger;
use Clonable\Translator\Model\Product\Condition\ConditionChain;
use Exception;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Catalog\Model\ResourceModel\Product\CollectionFactory;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\MessageQueue\PublisherInterface;
use Magento\Ui\Component\MassAction\Filter;

class MassTranslate extends Action
{
    private PublisherInterface $publisher;
    protected Filter $filter;
    protected CollectionFactory $collectionFactory;
    private Logger $logger;
    private ConfigManager $configManager;

    private ProductRepositoryInterface $productRepository;

    private ConditionChain $conditionChain;

    public function __construct(
        Context $context,
        Filter $filter,
        CollectionFactory $collectionFactory,
        PublisherInterface $publisher,
        logger $logger,
        ConfigManager $configManager,
        ProductRepositoryInterface $productRepository,
        ConditionChain             $conditionChain
    ){
        parent::__construct($context);
        $this->filter = $filter;
        $this->collectionFactory = $collectionFactory;
        $this->publisher = $publisher;
        $this->logger = $logger;
        $this->configManager = $configManager;
        $this->productRepository = $productRepository;
        $this->conditionChain = $conditionChain;
    }

    /**
     *
     * @throws LocalizedException
     */
    public function execute()
    {
        if (!$this->configManager->isEnabled(0)) {
            $this->messageManager->addErrorMessage(
                __('Clonable Translator is disabled. Please enable it in the configuration.')
            );
            return $this->_redirect($this->_redirect->getRefererUrl());
        }
        $collection = $this->filter->getCollection($this->collectionFactory->create());
        $productCount = $this->processCollection($collection);

        $this->messageManager->addSuccessMessage(
            __('A total of %1 product(s) have been added to the queue for translation.', $productCount)
        );
        return $this->_redirect($this->_redirect->getRefererUrl());
    }

    /**
     * @param $collection
     * @return int
     */
    private function processCollection($collection): int
    {
        $productCount = 0;

        foreach ($collection as $product) {
            try {
                $storeIds = $product->getStoreIds();
                foreach ($storeIds as $storeId) {
                    try {
                        $product = $this->productRepository->getById($product->getId(), false, $storeId, true);
                        $this->conditionChain->process($product, true);
                        $productCount++;
                    } catch (NoSuchEntityException $e) {
                        continue;
                    }
                }
            } catch (Exception $e) {
                $this->logger->error(
                    __('Error adding product ID %1 to the queue: %2', $product->getId(), $e->getMessage())
                );
                $this->messageManager->addErrorMessage(
                    __('Error adding product ID %1 to the queue: %2', $product->getId(), $e->getMessage())
                );
            }
        }

        return $productCount;
    }
}

