<?php

namespace Clonable\Translator\Model\Queue\Consumer;

use Clonable\Translator\Model\Product\TranslatorProduct;
use Magento\Framework\MessageQueue\ConsumerConfigurationInterface;
use Magento\Framework\MessageQueue\ConsumerInterface;

class Product implements ConsumerInterface
{
    private TranslatorProduct $translatorProduct;
    private ConsumerConfigurationInterface $configuration;

    public function __construct
    (
        ConsumerConfigurationInterface $configuration,
        TranslatorProduct $translatorProduct
    ){
        $this->configuration = $configuration;
        $this->translatorProduct = $translatorProduct;
    }

    /**
     * @param null $maxNumberOfMessages
     */
    public function process($maxNumberOfMessages = null): void
    {
        $queue = $this->configuration->getQueue();
        $this->translatorProduct->processMessage($queue);
        if (!isset($maxNumberOfMessages)) {
            $this->runDaemonMode($queue);
        } else {
            $this->run($queue, $maxNumberOfMessages);
        }
    }

    private function runDaemonMode($queue): void
    {
        while (true) {
            $this->translatorProduct->processMessage($queue);
        }
    }

    private function run($queue, $maxNumberOfMessages): void
    {
        for ($i = 1; $i < $maxNumberOfMessages; $i++) {
            $this->translatorProduct->processMessage($queue);
        }
    }
}
