<?php

namespace Clonable\Translator\Model\Service\Product;

use Clonable\Translator\Model\Product\Condition\ConditionChain;
use Magento\Bundle\Model\Product\Type as BundleType;
use Magento\Catalog\Api\Data\ProductInterface;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\ConfigurableProduct\Model\Product\Type\Configurable;

class ProcessAssociatedProducts
{
    private ProductRepositoryInterface $productRepository;
    private ConditionChain $conditionChain;
    public function __construct
    (
        ConditionChain $conditionChain,
        ProductRepositoryInterface $productRepository
    ){
        $this->conditionChain = $conditionChain;
        $this->productRepository = $productRepository;
    }

    public function processAssociatedProducts(ProductInterface $product): void
    {
        $associatedProducts = $this->getAssociatedProducts($product);

        foreach ($associatedProducts as $associatedProduct) {
            /** @var ProductInterface $associatedProduct */
            $associatedProduct = $this->productRepository->get($associatedProduct->getSku());
            // todo maybe for each store?
            $this->conditionChain->process($associatedProduct);
        }
    }

    private function getAssociatedProducts(ProductInterface $product)
    {
        switch ($product->getTypeId()) {
            case Configurable::TYPE_CODE:
                return $this->getConfigurableAssociatedProducts($product);
            case BundleType::TYPE_CODE:
                return $this->getBundleAssociatedProducts($product);
            default:
                return [];
        }
    }

    private function getConfigurableAssociatedProducts(ProductInterface $product)
    {
        return $product->getTypeInstance()->getUsedProducts($product);
    }

    private function getBundleAssociatedProducts(ProductInterface $product)
    {
        return $product->getTypeInstance()->getSelectionsCollection(
            $product->getTypeInstance()->getOptionsIds($product),
            $product
        );
    }
}
