<?php

namespace Clonable\Translator\Model\Queue\Consumer;

use Clonable\Translator\Api\ReportLogsRepositoryInterface;
use Clonable\Translator\Exception\CategoryTranslationException;
use Clonable\Translator\Model\Category\CategoryTranslator;
use Magento\Framework\MessageQueue\ConsumerConfigurationInterface;
use Magento\Framework\MessageQueue\EnvelopeInterface;
use Magento\Framework\MessageQueue\QueueInterface;
use Clonable\Translator\Model\ReportLogsFactory;
use Magento\Framework\Serialize\Serializer\Json;

class Category extends BaseConsumer
{
    private CategoryTranslator $translatorCategory;

    public function __construct
    (
        ConsumerConfigurationInterface $configuration,
        ReportLogsRepositoryInterface  $reportLogsRepository,
        ReportLogsFactory $reportLogsFactory,
        CategoryTranslator $translatorCategory,
        Json $json
    ){
        parent::__construct($configuration, $reportLogsRepository, $reportLogsFactory, $json);
        $this->translatorCategory = $translatorCategory;
    }

    public function handleMessage(QueueInterface $queue, EnvelopeInterface $message)
    {
        try {
            $decoded = $this->json->unserialize($message->getBody());
            $this->translatorCategory->translate($decoded);
            $queue->acknowledge($message);
        } catch (CategoryTranslationException $exception) {
            $queue->reject($message, $exception->shouldRequeue(), $exception->getMessage());
        }
    }
}
