<?php

namespace Clonable\Translator\Model;

use Magento\Framework\Model\AbstractModel;
use Clonable\Translator\Api\Data\ReportLogsInterface;
class ReportLogs extends AbstractModel implements ReportLogsInterface
{

    protected function _construct()
    {
        $this->_init(\Clonable\Translator\Model\ResourceModel\ReportLogs::class);
    }

    /**
     * @return string|null
     */
    public function getId(): ?string
    {
        return $this->getData(ReportLogsInterface::ID);
    }

    /**
     * @return string
     */
    public function getMessage(): string
    {
        return $this->getData(ReportLogsInterface::MESSAGE);
    }

    /**
     * @return string
     */
    public function getCreatedAt(): string
    {
        return $this->getData(ReportLogsInterface::CREATED_AT);
    }

    /**
     * Get store ID
     *
     * @return string
     */
    public function getStoreiId()
    {
        return $this->getData(ReportLogsInterface::STORE_ID);
    }

    /**
     * Set ID
     *
     * @param string $id
     * @return \Clonable\Translator\Api\Data\ReportLogsInterface
     */
    public function setId($id): ReportLogsInterface
    {
        return $this->setData(ReportLogsInterface::ID, $id);
    }
    /**
     * Set ID
     *
     * @param string $message
     * @return \Clonable\Translator\Api\Data\ReportLogsInterface
     */
    public function setMessage(string $message): ReportLogsInterface
    {
        return $this->setData(ReportLogsInterface::MESSAGE, $message);
    }

    /**
     * Set ID
     *
     * @param string $createdAt
     * @return \Clonable\Translator\Api\Data\ReportLogsInterface
     */
    public function setCreatedAt(string $createdAt): ReportLogsInterface
    {
        return $this->setData(ReportLogsInterface::CREATED_AT, $createdAt);
    }

    /**
     * @return string
     */
    public function getStackTrace(): string
    {
        return $this->getData(ReportLogsInterface::STACK_TRACE);
    }

    /**
     * Set store ID
     *
     * @param string $storeId
     * @return \Clonable\Translator\Api\Data\ReportLogsInterface
     */
    public function setStoreId(string $storeId): ReportLogsInterface
    {
        return $this->setData(ReportLogsInterface::STORE_ID, $storeId);
    }

}
