<?php

namespace Clonable\Translator\Model\Queue\Consumer;

use Clonable\Translator\Api\ReportLogsRepositoryInterface;
use Clonable\Translator\Model\Cms\TranslatorCms;
use Magento\Framework\MessageQueue\ConsumerConfigurationInterface;
use Magento\Framework\MessageQueue\EnvelopeInterface;
use Magento\Framework\MessageQueue\QueueInterface;
use Magento\Framework\Serialize\Serializer\Json;
use Clonable\Translator\Model\ReportLogsFactory;

class Cms extends BaseConsumer
{
    private TranslatorCms $translatorCms;
    private ConsumerConfigurationInterface $configuration;

    public function __construct
    (
        ConsumerConfigurationInterface $configuration,
        ReportLogsRepositoryInterface  $reportLogsRepository,
        ReportLogsFactory $reportLogsFactory,
        TranslatorCms $translatorCms,
        Json $json
    ){
        parent::__construct($configuration, $reportLogsRepository, $reportLogsFactory, $json);
        $this->configuration = $configuration;
        $this->translatorCms = $translatorCms;
    }


    public function handleMessage(QueueInterface $queue, EnvelopeInterface $message)
    {
        try {
            $decoded = $this->json->unserialize($message->getBody());
            $this->translatorCms->translate($decoded);
            $queue->acknowledge($message);
        } catch (\Throwable $exception) {
            $queue->reject($message, false, $exception->getMessage());
        }
    }
}

