<?php

namespace Clonable\Translator\Model\Queue\Consumer;

use Clonable\Translator\Api\ReportLogsRepositoryInterface;
use Clonable\Translator\Exception\ProductTranslationException;
use Clonable\Translator\Model\Product\ProductTranslator;
use Magento\Framework\MessageQueue\ConsumerConfigurationInterface;
use Clonable\Translator\Model\ReportLogsFactory;
use Magento\Framework\MessageQueue\EnvelopeInterface;
use Magento\Framework\MessageQueue\QueueInterface;
use Magento\Framework\Serialize\Serializer\Json;

class Product extends BaseConsumer
{
    private ProductTranslator $translatorProduct;

    public function __construct
    (
        ConsumerConfigurationInterface $configuration,
        ReportLogsRepositoryInterface  $reportLogsRepository,
        ReportLogsFactory $reportLogsFactory,
        ProductTranslator $translatorProduct,
        Json $json
    ){
        parent::__construct($configuration, $reportLogsRepository, $reportLogsFactory, $json);
        $this->translatorProduct = $translatorProduct;
    }

    public function handleMessage(QueueInterface $queue, EnvelopeInterface $message)
    {
        try {
            $decoded = $this->json->unserialize($message->getBody());
            $this->translatorProduct->translate($decoded);
            $queue->acknowledge($message);
        } catch (ProductTranslationException $exception) {
            $queue->reject($message, $exception->shouldRequeue(), $exception->getMessage());
        }
    }
}
