<?php

namespace Clonable\Translator\Model\Product\Condition;

use Clonable\Translator\Model\ConfigManager;
use Magento\Catalog\Api\Data\ProductInterface;
use Magento\Framework\MessageQueue\PublisherInterface;
use Magento\Framework\Serialize\Serializer\Json;

class ConditionChain
{
    /**
     * @var ConditionHandlerInterface[]
     */
    private $handlers;
    private ConfigManager $configManager;
    private PublisherInterface $publisher;
    private JSON $json;


    public function __construct(
        PublisherInterface $publisher,
        ConfigManager      $configManager,
        JSON $json,
        array              $handlers = []
    )
    {
        $this->handlers = $handlers;
        $this->publisher = $publisher;
        $this->configManager = $configManager;
        $this->json = $json;
    }

    public function process(ProductInterface $product, bool $force = false): bool
    {
        if ($this->shouldProcess($product, $force)) {
            $payload = $this->json->serialize([
                'productId' => $product->getId(),
                'storeId' => $product->getStoreId(),
                'force' => $force
            ]);
            $this->publisher->publish($this->configManager->getTopicQueueForProduct(), $payload);
            return true;
        } else {
            return false;
        }
    }

    public function shouldProcess(ProductInterface $product, bool $force = false): bool
    {
        foreach ($this->handlers as $handler) {
            if ($force && $handler instanceof ExcludeAutoTranslationHandler) {
                // When forced, we ignore individual product exclusions
                continue;
            }

            if (!$handler->handle($product)) {
                return false;
            }
        }

        return true;
    }
}
