# Changelog

## Version 2.0.7
- Improve compatibility with Magento < 2.4.5

## Version 2.0.6
- Preserve inheritance when saving product
- Fix bulk translate success message: it now shows the correct amount of dispatched jobs
- Queues have been renamed for consistency (dashes have been replaced with dots). Keep in mind that jobs still in the queue during the update will be lost and need to be dispatched again.
- Fixed RabbitMQ compatibility
- Remove deprecated implicit nullability for PHP 8.4

## Version 2.0.5
- When translating URL keys for products, check if the new URL key has already been used.
- Performance improvements for the mass translate actions.

## Version 2.0.4
- Added sanity checks for URL key translations within the Clonable scope.
- Make sure that URL keys cannot be translated for the global scope.
- Also added a warning op the settings page.

## Version 2.0.3
- Improved transliteration for URL keys based on product names.
- Fixed bug with creation of rewrites for product URL key translations.

## Version 2.0.2
- Changed method that was sometimes undefined for some queue handlers.

## Version 2.0.1
- Fixed error with setup:di:compile command

## Version 2.0.0

When upgrading from previous versions and where changes to the app/etc/config.php file were made, some changes have to
be corrected. Custom queue overrides can be removed as they are no longer required for the Clonable plugin.
Queues have been merged, changing their names:
* clonable.translator.product.queue.db    --> clonable.translator.product.queue
* clonable.translator.product.queue.amqp  --> clonable.translator.product.queue
* clonable.translator.category.db         --> clonable.translator.category.queue
* clonable.translator.category.amqp       --> clonable.translator.category.queue
* clonable.translator.cms.queue.db        --> clonable.translator.cms.queue
* clonable.translator.cms.queue.amqp      --> clonable.translator.cms.queue

- Overhaul: The queuing system has been changed to harness the power of Magento's automatic queues scheduling
- New: Option to synchronously translate the products
- Bugfix: Extra check for duplicate file extensions for rewrites
- Bugfix: Ensure the correct store is set when translating categories
- Change: split up Clonable logs into own tab

## Version 1.4.0

- New: Added support for catalog suffixes in urls
- New: Separate button for forcing translations in product mass translations
- Fixed a bug that caused the url rewrites for products not to generate

## Version 1.3.0

- New: Added url translations for categories
- Tweak: Restructured Clonable settings page

## Version 1.2.4

- Improved queue efficiency

## Version 1.2.3

- Fixed issue with observers.

## Version 1.2.2

- Improved error reporting when linking the plug-in to Clonable.
- Fixed a bug that caused clones using their own domain name to be unlinkable.
- Fixed a bug that resulted in an incorrect API response in case authentication was insufficient.

## Version 1.2.1

- Fixed a bug in a disabled module that occurred during installation
- Fixed a bug that could cause an error on PHP 7.4

## Version 1.2.0

- Added option for name-based url key translations. This improves the consistency between the translated product name
  and the url key.

## Version 1.1.1

- Added support for non-subfolder clones

## Version 1.1.0

- Allow products to be re-translated. This allows users to apply new exclusions and rules from Clonable to their Magento
  product catalog. To re-translate a
  product, use the mass translation feature. When re-translating, any manual changes will be overwritten.
- Fixed issue where the locale would not be correctly determined when deploying js-translations.json via the CLI.
- Fixed queue not respecting the `maxNumberOfMessages` parameter.
- Fixed queue duplicating work.
- Tweaked the queue to wait a few seconds when processing a product failed.
- Improved condition checking before putting product on the translation queue.

## Version 1.0.1

- Enable support for RabbitMQ queueing system

## Version 1.0.0

- Initial release