<?php

namespace Clonable\Translator\Model\Category\Condition;

use Clonable\Translator\Model\Category\Condition\ConditionHandlerInterface;
use Clonable\Translator\Model\ConfigManager;
use Magento\Catalog\Api\Data\CategoryInterface;

class HasCloneAndSiteHandler implements ConditionHandlerInterface
{
    private ConfigManager $configManager;

    public function __construct(
        ConfigManager $configManager
    ){
        $this->configManager = $configManager;
    }

    public function handle(CategoryInterface $category): bool
    {
        $store_id = $category->getStoreId();
        if ($this->configManager->getSiteId($store_id) !== null &&
            $this->configManager->getCloneId($store_id) !== null) {
            return true;
        }

        return false;
    }
}