<?php

namespace Clonable\Translator\Model\Config\Backend;

use Magento\Framework\App\Cache\TypeListInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Config\Value;
use Magento\Framework\Data\Collection\AbstractDb;
use Magento\Framework\Exception\LocalizedException;
use Clonable\Translator\Model\ConfigManager;
use Magento\Framework\Model\Context;
use Magento\Framework\Model\ResourceModel\AbstractResource;
use Magento\Framework\Registry;

class ApiKey extends Value
{
    public function __construct(
        Context           $context,
        Registry          $registry,
        ScopeConfigInterface $config,
        TypeListInterface $cacheTypeList,
        ?AbstractResource $resource = null,
        ?AbstractDb       $resourceCollection = null,
        array             $data = []
    ){
        parent::__construct($context, $registry, $config, $cacheTypeList, $resource, $resourceCollection, $data);
    }

    protected function _beforeSave()
    {
        $value = $this->getValue();
        if (empty($value)) {
            throw new LocalizedException(__('Please enter a valid API key.'));
        }
        return parent::_beforeSave();
    }
}
