<?php

namespace Clonable\Translator\Api\Data;

interface ReportLogsInterface
{
    public const ID = 'id';
    public const MESSAGE = 'log_message';
    public const CREATED_AT = 'created_at';
    public const STACK_TRACE = 'stack_trace';
    public const STORE_ID = 'store';

    /**
     * @return string|null
     */
    public function getId(): ?string;

    /**
     *
     * @return string
     */
    public function getMessage(): string;

    /**
     * @return string
     */
    public function getCreatedAt(): string;

    /**
     * Get store ID
     *
     * @return string
     */
    public function getStoreiId();

    /**
     * Set ID
     *
     * @param string $id
     * @return \Clonable\Translator\Api\Data\ReportLogsInterface
     */
    public function setId(string $id): ReportLogsInterface;

    /**
     * Set message
     *
     * @param string $message
     * @return \Clonable\Translator\Api\Data\ReportLogsInterface
     * @throws \Exception
     */
    public function setMessage(string $message): ReportLogsInterface;

    /**
     * Set created at
     *
     * @param string $createdAt
     * @return \Clonable\Translator\Api\Data\ReportLogsInterface
     */
    public function setCreatedAt(string $createdAt): ReportLogsInterface;

    /**
     * Set store ID
     *
     * @param string $storeId
     * @return \Clonable\Translator\Api\Data\ReportLogsInterface
     */
    public function setStoreId(string $storeId): ReportLogsInterface;
}
