<?php

namespace Clonable\Translator\Api;

use Clonable\Translator\Api\Data\ReportLogsInterface;

interface ReportLogsRepositoryInterface
{
    /**
     * Save log entry.
     *
     * @param \Clonable\Translator\Api\Data\ReportLogsInterface $log
     * @return \Clonable\Translator\Api\Data\ReportLogsInterface
     */
    public function save(\Clonable\Translator\Api\Data\ReportLogsInterface $log): \Clonable\Translator\Api\Data\ReportLogsInterface;

    /**
     * Get log entry by ID.
     *
     * @param int $id
     * @return \Clonable\Translator\Api\Data\ReportLogsInterface
     */
    public function getById(int $id): \Clonable\Translator\Api\Data\ReportLogsInterface;

    /**
     * Delete log entry.
     *
     * @param string $id
     * @return void
     */
    public function deleteById($id): void;
}
