<?php

namespace Clonable\Translator\Api\Service;

use Magento\Store\Model\Store;

interface ClonableTranslatorApiInterface
{

    /**
     * Translate a URL using the external API.
     *
     * @param string $urlKey
     * @param Store|null $store
     * @return string
     */
    public function translateUrlKey(
        string $urlKey,
        Store $store
    ): string;

    public function translateText(
        string $text,
        Store $store
    ): string;
}
