<?php

namespace Clonable\Translator\Block\Adminhtml\System\Config;

use Magento\Framework\Module\ResourceInterface;
use Magento\Framework\View\Element\Template;
use Clonable\Translator\Model\ResourceModel\ReportLogs\CollectionFactory as ReportLogsCollectionFactory;
use Clonable\Translator\Model\ConfigManager;
use Magento\Store\Model\StoreManagerInterface;


class ModuleInfoTemplate extends Template
{

    public const MODULE_NAME = 'Clonable_Translator';

    /**
     * @var ResourceInterface
     */
    private ResourceInterface $moduleResource;

    /**
     * @var ReportLogsCollectionFactory
     */
    private ReportLogsCollectionFactory $reportLogsCollectionFactory;

    private ConfigManager $configManager;

    private StoreManagerInterface $storeManager;

    public function __construct(
        Template\Context $context,
        ResourceInterface $moduleResource,
        ReportLogsCollectionFactory $reportLogsCollectionFactory,
        ConfigManager $configManager,
        StoreManagerInterface $storeManager,
        array $data = []
    ){
        parent::__construct($context, $data);
        $this->moduleResource = $moduleResource;
        $this->reportLogsCollectionFactory = $reportLogsCollectionFactory;
        $this->configManager = $configManager;
        $this->storeManager = $storeManager;
    }

    public function getModuleVersion()
    {
        return $this->moduleResource->getDbVersion(self::MODULE_NAME);
    }

    public function getErrorsCount()
    {
        $collection = $this->reportLogsCollectionFactory->create();
        return $collection->getSize();
    }

    public function getEditReportLogsUrl()
    {
        return $this->getUrl('clonable_translator/report/index');
    }
    public function getAjaxUrl()
    {
        return $this->getUrl('clonable_translator/siteInfo/update');
    }

    public function getStoreId()
    {
        return $this->getRequest()->getParam('store');

    }

    public function getStoreCode()
    {
        return $this->_storeManager->getStore()->getCode();
    }

    public function getSiteId($storeId = null)
    {
        return $this->configManager->getSiteId($storeId);
    }

    public function getOriginalLanguage($storeId = null)
    {
        return $this->configManager->getOriginalLanguage($storeId);
    }

    public function getTargetLanguage($storeId = null)
    {
        return $this->configManager->getTargetLanguage($storeId);
    }

    public function getCloneId($storeId = null)
    {
        return $this->configManager->getCloneId($storeId);
    }

}
