<?php
declare(strict_types=1);

namespace Clonable\Translator\Block\Adminhtml\System\Config;

use Clonable\Translator\Model\ConfigManager;
use Magento\Backend\Block\Template\Context;
use Magento\Config\Block\System\Config\Form\Field;
use Magento\Framework\Data\Form\Element\AbstractElement;

class ProductUrlKeyScopeNote extends Field
{
    public function __construct(
        Context $context,
        ConfigManager $configManager,
        array $data = []
    ) {
        $this->configManager = $configManager;
        parent::__construct($context, $data);
    }

    protected function _getElementHtml(AbstractElement $element)
    {
        $status = $this->configManager->getProductUrlKeyScopeStatus();

        $style = $status['ok']
            ? 'background:#e6f6ec;border:1px solid #b7ebc6;color:#1a7f37;padding:8px;border-radius:4px;'
            : 'background:#fff6f6;border:1px solid #ffd6d6;color:#a40000;padding:8px;border-radius:4px;';

        $explain = $status['ok']
            ? ''
            : __('Set **Stores → Attributes → Product → url_key → Scope** to **Store View** to enable localized product URLs. With Global/Website scope, changing url_key would affect All Store Views, so the translator skips URL-key updates.');

        return sprintf(
            '<div style="%s"><strong>%s</strong><br/><small>%s</small></div>',
            $style,
            $this->escapeHtml((string)$status['message']),
            $this->escapeHtml((string)$explain)
        );
    }
}