<?php

namespace Clonable\Translator\Block\Adminhtml\System\Config;

use Clonable\Translator\Model\ResourceModel\ReportLogs\CollectionFactory as ReportLogsCollectionFactory;
use Magento\Backend\Block\Context;
use Magento\Backend\Model\Auth\Session;
use Magento\Config\Block\System\Config\Form\Fieldset;
use Magento\Framework\Data\Form\Element\AbstractElement;
use Magento\Framework\View\Helper\Js;
use Magento\Framework\View\Helper\SecureHtmlRenderer;

class Report extends Fieldset
{

    public function __construct(
        Context                     $context,
        Session                     $authSession,
        Js                          $jsHelper,
        ReportLogsCollectionFactory $reportLogsCollectionFactory,
        array                       $data = [],
        ?SecureHtmlRenderer         $secureRenderer = null
    )
    {
        parent::__construct($context, $authSession, $jsHelper, $data, $secureRenderer);
        $this->reportLogsCollectionFactory = $reportLogsCollectionFactory;
    }

    public function render(AbstractElement $element)
    {
        $html = $this->_getFieldHtml($element);
        $html = str_replace(
            'clonable_information]" type="hidden" value="0"',
            'clonable_information]" type="hidden" value="1"',
            $html
        );

        return preg_replace('/onclick="Fieldset\.toggleCollapse\(.*?\)"/', '', $html);

    }

    protected function _getFieldHtml(AbstractElement $element)
    {
        $block = $this->_layout->getBlock('clonable_report');
        if ($block) {
            return $block->toHtml();
        }
        return '';
    }
}
