<?php

namespace Clonable\Translator\Controller\Adminhtml\Category;

use Clonable\Translator\Model\Category\CategoryTranslator;
use Clonable\Translator\Model\Logger\Logger;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\Result\RedirectFactory;
use Magento\Framework\Serialize\Serializer\Json;
use Clonable\Translator\Model\ReportLogsFactory;

class TranslateCurrentCategory extends Action
{
    const ADMIN_RESOURCE = 'Clonable_Translator::translateCategories';

    private Logger $logger;
    private CategoryTranslator $translator;
    private RedirectFactory $redirectFactory;
    private JSON $json;

    public function __construct(
        Logger             $logger,
        Context            $context,
        CategoryTranslator $translator,
        RedirectFactory    $redirectFactory,
        Json               $json
    )
    {
        parent::__construct($context);
        $this->logger = $logger;
        $this->translator = $translator;
        $this->redirectFactory = $redirectFactory;
        $this->json = $json;
    }

    /**
     * @inheritDoc
     */
    public function execute()
    {
        $store_id = (int)$this->getRequest()->getParam('store');
        $category_id = (int)$this->getRequest()->getParam('category');

        $result = $this->redirectFactory->create();
        $result->setPath('catalog/category/edit', ['_current' => true]);
        if ($store_id === 0) {
            $this->messageManager->addErrorMessage(__('You should switch to a storeview first, before you can translate this category.'));
            return $result;
        }

        $result->setPath('catalog/category/edit', ['id' => $category_id, '_current' => true, 'store' => $store_id]);
        if ($category_id === 0) {
            $this->messageManager->addErrorMessage(__('Could not translate the category, should switch to a specific category first.'));
            return $result;
        }

        try {
            // You can either run a dry-run via your translator service:
            $json_data = $this->json->serialize([
                'categoryId' => $category_id,
                'storeId' => $store_id,
                'force' => true
            ]);
            $this->translator->translate($json_data);
            $this->messageManager->addSuccessMessage(__('Translation complete for category #%1.', $category_id));
        } catch (\Exception $e) {
            $this->messageManager->addErrorMessage(__('Translation failed: %1', $e->getMessage()));
        }

        return $result;
    }
}