<?php

namespace Clonable\Translator\Controller\Adminhtml\Report;

use Clonable\Translator\Api\ReportLogsRepositoryInterface;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\Result\Redirect;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Exception\LocalizedException;
use Clonable\Translator\Model\ResourceModel\ReportLogs\CollectionFactory as ReportLogsCollectionFactory;

class MassDelete extends Action
{
    private ReportLogsRepositoryInterface $reportLogsRepository;
    private ReportLogsCollectionFactory $collectionFactory;

    public function __construct(
        Context $context,
        ReportLogsRepositoryInterface $reportLogsRepository,
        ReportLogsCollectionFactory $collectionFactory
    ) {
        parent::__construct($context);
        $this->reportLogsRepository = $reportLogsRepository;
        $this->collectionFactory = $collectionFactory;
    }

    public function execute()
    {
        $request = $this->getRequest();

        $excluded  = $request->getParam('excluded', []);
        $selected  = $request->getParam('selected', []);

        if (!empty($selected)) {
            if (!is_array($selected)) {
                $selected = [$selected];
            }
            $ids = $selected;
        } else {
            // Fetch *all* IDs, then remove any that were explicitly excluded
            $allIds = $this->collectionFactory
                ->create()
                ->getAllIds();

            if (!is_array($excluded)) {
                $excluded = [$excluded];
            }
            $ids = array_diff($allIds, $excluded);
        }


        if (empty($ids)) {
            $this->messageManager->addErrorMessage(__('Please select item(s) to delete.'));
        } else {
            try {
                foreach ($ids as $id) {
                    $this->reportLogsRepository->deleteById($id);
                }
                $this->messageManager->addSuccessMessage(
                    __('A total of %1 record(s) have been deleted.', count($ids))
                );
            } catch (LocalizedException $e) {
                $this->messageManager->addErrorMessage($e->getMessage());
            } catch (\Exception $e) {
                $this->messageManager->addErrorMessage(
                    __('An error occurred while deleting records.')
                );
            }
        }

        /** @var Redirect $resultRedirect */
        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        return $resultRedirect->setPath('*/*/index');
    }
}
