<?php

namespace Clonable\Translator\Controller\Adminhtml\SiteInfo;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\Result\JsonFactory;
use Clonable\Translator\Model\Service\UpdateSiteInfoService;
use Clonable\Translator\Model\ConfigManager;

class Update extends Action
{
    protected JsonFactory $resultJsonFactory;

    private UpdateSiteInfoService $updateSiteInfoService;

    private ConfigManager $configManager;

    public function __construct(
        Context $context,
        JsonFactory $resultJsonFactory,
        UpdateSiteInfoService $updateSiteInfoService,
        ConfigManager $configManager
    ){
        parent::__construct($context);
        $this->resultJsonFactory = $resultJsonFactory;
        $this->updateSiteInfoService = $updateSiteInfoService;
        $this->configManager = $configManager;
    }

    public function execute()
    {
        $result = $this->resultJsonFactory->create();
        try {
            $storeId = $this->getRequest()->getParam('storeId');
            $apikey = $this->configManager->decryptApiKey($this->configManager->getApiKey($storeId));
            $this->updateSiteInfoService->updateSiteInfo($apikey, $storeId);
            $result->setData([
                'success' => true,
                'message' => __('Site information updated')
            ]);
        } catch (\Exception $e) {
            $result->setData([
                'success' => false,
                'message' => __($e->getMessage())
            ]);
        }
        return $result;
    }
}
