<?php

namespace Clonable\Translator\Model\Product\Condition;

use Clonable\Translator\Model\ConfigManager;
use Magento\Catalog\Api\Data\ProductInterface;

class HasCloneAndSiteHandler implements ConditionHandlerInterface
{
    private ConfigManager $configManager;

    public function __construct(
        ConfigManager $configManager
    ){
        $this->configManager = $configManager;
    }

    public function handle(ProductInterface $product): bool
    {
        $store_id = $product->getStoreId();
        if ($this->configManager->getSiteId($store_id) !== null &&
            $this->configManager->getCloneId($store_id) !== null) {
            return true;
        }

        return false;
    }
}