<?php

namespace Clonable\Translator\Plugin;

use Magento\Framework\App\Config\Value;
use Magento\Framework\Exception\LocalizedException;
use Clonable\Translator\Api\Service\ClonableValidateApiKeyInterface;
use Clonable\Translator\Model\Service\UpdateSiteInfoService;
use Clonable\Translator\Model\ConfigManager;

class ApiKeyValidatorBeforeSavePlugin

{
    private ClonableValidateApiKeyInterface $clonableValidateApiKey;

    private UpdateSiteInfoService $updateSiteInfoService;

    private ConfigManager $configManager;

    public function __construct
    (
        ClonableValidateApiKeyInterface $clonableValidateApiKey,
        UpdateSiteInfoService $updateSiteInfoService,
        ConfigManager $configManager
    ){
        $this->clonableValidateApiKey = $clonableValidateApiKey;
        $this->updateSiteInfoService = $updateSiteInfoService;
        $this->configManager = $configManager;
    }

    /**
     * Before save plugin to validate API key.
     *
     * @param Value $subject
     * @return void
     * @throws LocalizedException
     */
    public function beforeSave(Value $subject)
    {
        $fieldId = $subject->getPath();
        if ($fieldId === ConfigManager::API_KEY) {
            $this->validateApiKey($subject);
        }
    }

    /**
     * @throws LocalizedException
     */
    private function validateApiKey(Value $subject)
    {
            $value = $subject->getValue();
            $isValueChanged = $subject->isValueChanged();
            $storeId = $subject->getScopeId();

            if ($isValueChanged) {
                $this->updateSiteInfoService->updateSiteInfo($subject->getValue(), $storeId);
                if (!$value || !$this->isValidApiKey($value)) {
                    throw new LocalizedException(__('Please enter a valid API key.'));
                }
                $subject->setValue($this->configManager->encryptApiKey($value));
            }
    }

    private function isValidApiKey($value)
    {
        return $this->clonableValidateApiKey->validateApiKey($value);
    }
}
