<?php

namespace Clonable\Translator\Plugin;

use Clonable\Translator\Model\Product\Condition\ConditionChain;
use Clonable\Translator\Model\Service\Product\ProcessAssociatedProducts;
use Magento\Catalog\Api\Data\ProductInterface;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Catalog\Controller\Adminhtml\Product\Action\Attribute\Save;
use Magento\Catalog\Helper\Product\Edit\Action\Attribute;
use Magento\Framework\Controller\Result\Redirect;
use Magento\Framework\Exception\NoSuchEntityException;

class ProductAttributeSaveExecutePlugin
{
    /**
     * @var Attribute
     */
    protected Attribute $attributeHelper;

   private ConditionChain $conditionChain;

   private ProcessAssociatedProducts $processAssociatedProducts;

    private ProductRepositoryInterface $productRepository;

    public function __construct
    (
        Attribute $attributeHelper,
        ConditionChain $conditionChain,
        ProcessAssociatedProducts $processAssociatedProducts,
        ProductRepositoryInterface $productRepository

    ){
        $this->attributeHelper = $attributeHelper;
        $this->conditionChain = $conditionChain;
        $this->processAssociatedProducts = $processAssociatedProducts;
        $this->productRepository = $productRepository;
    }

    /**
     * @param Save $subject
     * @param Redirect $result
     * @return Redirect
     */
    public function afterExecute(Save $subject, Redirect $result): Redirect
    {
            /** @var ProductInterface[] $products */
            $products = $this->attributeHelper->getProducts()->load()->getItems();
            foreach ($products as $product) {
                foreach ($product->getStoreIds() as $storeId) {
                    try {
                        $productByStore = $this->productRepository->get($product->getSku(), false, $storeId, true);
                        $this->conditionChain->process($productByStore);
                        $this->processAssociatedProducts->processAssociatedProducts($productByStore);
                    } catch (NoSuchEntityException $e) {
                        continue;
                    }
                }
            }

        return $result;
    }
}
