<?php

namespace Clonable\Translator\Setup;

use Clonable\Translator\Model\ConfigManager;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Config\Storage\WriterInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\UpgradeDataInterface;
use Magento\Store\Model\ScopeInterface;
use Magento\Store\Model\StoreManagerInterface;

class UpgradeData implements UpgradeDataInterface
{
    private ScopeConfigInterface $scopeConfig;
    private WriterInterface $configWriter;
    private StoreManagerInterface $storeManager;

    public function __construct(
        ScopeConfigInterface $scopeConfig,
        WriterInterface $writer,
        StoreManagerInterface $storeManager
    )
    {
        $this->scopeConfig = $scopeConfig;
        $this->configWriter = $writer;
        $this->storeManager = $storeManager;
    }

    public static function getDependencies()
    {
        return [];
    }

    public function getAliases()
    {
        return [];
    }

    private const OLD_TRANSLATE_URL_KEY = 'translator/general/enable_translate_url_key';
    private const OLD_USE_NAME_BASED_URL_KEY_TRANSLATIONS = 'translator/general/use_name_based_url_key';
    private const OLD_ENABLE_AUTO_TRANSLATION = 'translator/general/enable_auto_translation';

    public function upgrade(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();
        if (version_compare($context->getVersion(), '1.3.0', '<')) {
            $this->migrateData();
            foreach ($this->storeManager->getWebsites() as $website) {
                $this->migrateData(ScopeInterface::SCOPE_WEBSITES, $website->getId());
                foreach ($this->storeManager->getStores() as $store) {
                    $this->migrateData(ScopeInterface::SCOPE_STORES, $store->getId());
                }
            }
        }
        $setup->endSetup();
    }

    /**
     * @param string $scope
     * @param int $scopeId
     * @return void
     */
    private function migrateData($scope = ScopeConfigInterface::SCOPE_TYPE_DEFAULT, $scopeId = 0) {
        $this->configWriter->save(
            ConfigManager::ENABLE_PRODUCT_AUTO_TRANSLATION,
            $this->scopeConfig->getValue(self::OLD_ENABLE_AUTO_TRANSLATION, $scope, $scopeId),
            $scope,
            $scopeId
        );

        $this->configWriter->save(
            ConfigManager::TRANSLATE_PRODUCT_URL_KEY,
            $this->scopeConfig->getValue(self::OLD_TRANSLATE_URL_KEY, $scope, $scopeId),
            $scope,
            $scopeId
        );

        $this->configWriter->save(
            ConfigManager::USE_PRODUCT_NAME_BASED_URL_KEY_TRANSLATIONS,
            $this->scopeConfig->getValue(self::OLD_USE_NAME_BASED_URL_KEY_TRANSLATIONS, $scope, $scopeId),
            $scope,
            $scopeId
        );
    }
}