<?php

namespace Clonable\Translator\Ui\Component\Listing\DataProvider;

use Magento\Framework\Api\FilterBuilder;
use Magento\Framework\Api\Search\ReportingInterface;
use Magento\Framework\Api\Search\SearchCriteriaBuilder;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\View\Element\UiComponent\DataProvider\DataProvider;
use Clonable\Translator\Model\ResourceModel\ReportLogs\CollectionFactory;

class ReportLogs extends DataProvider
{

    private $collection;

    public function __construct(
            $name, $primaryFieldName,
            $requestFieldName,
            ReportingInterface $reporting,
            SearchCriteriaBuilder $searchCriteriaBuilder,
            RequestInterface $request,
            FilterBuilder $filterBuilder,
            CollectionFactory $collectionFactory,
            array $meta = [], array $data = []
        ){
            parent::__construct(
                $name, $primaryFieldName,
                $requestFieldName, $reporting,
                $searchCriteriaBuilder, $request,
                $filterBuilder, $meta, $data);
            $this->collection = $collectionFactory->create();
        }

    public function getCollection()
    {
        return $this->collection;

    }
    public function getData()
    {
        if (!$this->getCollection()->isLoaded()) {
            $this->getCollection()->load();
        }
        return $this->getCollection()->toArray();
    }
}
