<?php

namespace Clonable\Translator\Block\Adminhtml\Category\Edit\Button;


use Magento\Backend\Block\Template;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\UrlInterface;
use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;

class RunCurrentCategoryTranslationAction extends Template implements ButtonProviderInterface
{
    private UrlInterface     $urlBuilder;
    private RequestInterface $request;

    public function __construct(
        Template\Context  $context,
        UrlInterface     $urlBuilder,
        RequestInterface $request,
        array             $data = []
    ) {
        parent::__construct($context, $data);
        $this->urlBuilder = $urlBuilder;
        $this->request    = $request;
    }

    public function getButtonData(): array
    {
        $store_id = $this->request->getParam('store');
        $category_id = $this->request->getParam('id');
        return [
            'label'      => __('Translate current category'),
            'on_click'   => "window.location.href = '{$this->getUrl('clonable_translator/category/translateCurrentCategory', [
                'store' => $store_id,
                'category' => $category_id,
            ])}';",
            'class'      => 'action-secondary',
            'sort_order' => 90,
        ];
    }
}