<?php

namespace Clonable\Translator\Block\Adminhtml\Product\Edit\Button;

use Magento\Backend\Block\Template;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\UrlInterface;
use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;

class RunProductTranslationAction extends Template implements ButtonProviderInterface
{
    private UrlInterface     $urlBuilder;
    private RequestInterface $request;

    public function __construct(
        Template\Context  $context,
        UrlInterface     $urlBuilder,
        RequestInterface $request,
        array             $data = []
    ) {
        parent::__construct($context, $data);
        $this->urlBuilder = $urlBuilder;
        $this->request    = $request;
    }

    public function getButtonData(): array
    {
        $product_id = $this->request->getParam('id');
        $store_id = $this->request->getParam('store');
        return [
            'label'      => __('Run translations'),
            'on_click'   => "window.location.href = '{$this->urlBuilder->getUrl('clonable_translator/product/runtranslations', [
                'product_id' => $product_id,
                'store_id' => $store_id,
            ])}';",
            'class'      => 'action-secondary',
            'sort_order' => 90,
        ];
    }
}