<?php

namespace Clonable\Translator\Block\Adminhtml\System\Config;

use Magento\Backend\Block\Template\Context;
use Magento\Config\Block\System\Config\Form\Field;
use Magento\Framework\Data\Form\Element\AbstractElement;
use Magento\Framework\View\Helper\SecureHtmlRenderer;
use Magento\Store\Model\Store;

class RunAllCategoryTranslations extends Field
{
    protected $_template = 'system/config/run_translations_button.phtml';

    public function __construct(Context $context, array $data = [], ?SecureHtmlRenderer $secureRenderer = null)
    {
        parent::__construct($context, $data, $secureRenderer);
    }

    public function getStoreId() {
        return (int) $this->getRequest()->getParam('store', Store::DEFAULT_STORE_ID);
    }

    /**
     * Render the button
     *
     * @param AbstractElement $element
     * @return string
     */
    public function render(AbstractElement $element)
    {
        $element->unsScope()->unsCanUseWebsiteValue()->unsCanUseDefaultValue();
        return parent::render($element);
    }

    /**
     * Return the ajax url for the button
     *
     * @return string
     */
    public function getAjaxUrl()
    {
        return $this->getUrl('clonable_translator/category/translateAllCategories', [
            'store' => $this->getStoreId()
        ]);
    }

    /**
     * Get the button and scripts contents
     *
     * @param AbstractElement $element
     * @return string
     */
    protected function _getElementHtml(AbstractElement $element)
    {
        return $this->_toHtml();
    }

    public function getButtonHtml() {
        $button = $this->getLayout()->createBlock(
            'Magento\Backend\Block\Widget\Button'
        )->setData(
            [
                'id' => 'run_translations_button',
                'label' => __('Translate all categories'),
            ]
        );
        return $button->toHtml();
    }
}