<?php

namespace Clonable\Translator\Controller\Adminhtml\Product;

use Clonable\Translator\Model\Product\ProductTranslator;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\Result\RedirectFactory;
use Magento\Framework\Serialize\Serializer\Json;

class RunTranslations extends Action
{
    const ADMIN_RESOURCE = 'Clonable_Translator::runTranslations';

    private ProductTranslator $translator;
    private RedirectFactory $redirectFactory;
    private JSON $json;

    public function __construct(
        Context           $context,
        ProductTranslator $translator,
        RedirectFactory   $redirectFactory,
        Json              $json
    )
    {
        parent::__construct($context);
        $this->translator = $translator;
        $this->redirectFactory = $redirectFactory;
        $this->json = $json;
    }

    public function execute()
    {
        $product_id = (int)$this->getRequest()->getParam('product_id');
        $store_id = (int)$this->getRequest()->getParam('store_id');

        $result = $this->redirectFactory->create();
        $result->setPath('catalog/product/edit', ['id' => $product_id, '_current' => false]);
        if ($store_id === 0) {
            $this->messageManager->addErrorMessage(__('No product or store specified'));
            return $result;
        }

        $result->setPath('catalog/product/edit', ['id' => $product_id, 'store' => $store_id, '_current' => false]);
        if ($product_id === 0) {
            $this->messageManager->addErrorMessage(__('No product specified'));
            return $result;
        }

        try {
            // You can either run a dry-run via your translator service:
            $json_data = $this->json->serialize([
                'productId' => $product_id,
                'storeId' => $store_id,
                'force' => true
            ]);
            $this->translator->translate($json_data);
            $this->messageManager->addSuccessMessage(__('Translation complete for product #%1.', $product_id));
        } catch (\Exception $e) {
            $this->messageManager->addErrorMessage(__('Translation failed: %1', $e->getMessage()));
        }

        return $result;
    }
}
