<?php

namespace Clonable\Translator\Exception;

use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Phrase;

class ProductTranslationException extends LocalizedException
{
    private bool $requeue;

    public function __construct(Phrase $phrase, ?\Exception $cause = null, $code = 0, bool $requeue = false)
    {
        parent::__construct($phrase, $cause, $code);
        $this->requeue = $requeue;
    }

    public function shouldRequeue(): bool {
        return $this->requeue;
    }
}