<?php

namespace Clonable\Translator\Model\Category\Condition;

use Clonable\Translator\Model\ConfigManager;
use Clonable\Translator\Model\Logger\Logger;
use Magento\Catalog\Api\Data\CategoryInterface;
use Magento\Framework\MessageQueue\PublisherInterface;
use Magento\Framework\Serialize\Serializer\Json;

class ConditionChain {

    /**
     * @var ConditionHandlerInterface[]
     */
    private $handlers;
    private ConfigManager $configManager;
    private PublisherInterface $publisher;
    private JSON $json;

    public function __construct(
        PublisherInterface $publisher,
        ConfigManager      $configManager,
        Json               $json,
        array              $handlers = []
    ) {
        $this->handlers = $handlers;
        $this->publisher = $publisher;
        $this->configManager = $configManager;
        $this->json = $json;
    }

    public function process(CategoryInterface $category, bool $force = false, ?int $debugging_index = null): void {
        if ($this->shouldProcess($category, $force)) {
            $payload = $this->json->serialize([
                'categoryId' => $category->getId(),
                'storeId' => $category->getStoreId(),
                'force' => $force,
                'debugging_index' => $debugging_index,
            ]);
            $this->publisher->publish($this->configManager->getTopicQueueForCategory(), $payload);
        }
    }

    public function shouldProcess(CategoryInterface $category, bool $force = false): bool {
        foreach ($this->handlers as $handler) {
            if ($force && $handler instanceof ExcludeAutoTranslationHandler) {
                // When forced, we ignore individual product exclusions
                continue;
            }

            if (!$handler->handle($category)) {
                return false;
            }
        }

        return true;
    }
}
