<?php

namespace Clonable\Translator\Model\Category\Condition;

use Clonable\Translator\Model\ConfigManager;
use Magento\Catalog\Api\Data\CategoryInterface;

class ExcludeAutoTranslationHandler implements ConditionHandlerInterface
{
    private $configManager;

    public function __construct(
        ConfigManager $configManager
    ){
        $this->configManager = $configManager;
    }

    public function handle(CategoryInterface $category): bool
    {
        if ($this->configManager->categoryIsExcludedFromTranslation($category)) {
            return false;
        }
        return true;
    }
}

