<?php

namespace Clonable\Translator\Model\Js;

use Clonable\Translator\Model\ConfigManager;
use Clonable\Translator\Model\Logger\Logger;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Phrase\Renderer\Composite;
use Magento\Framework\Phrase\Renderer\Translate;
use Magento\Framework\TranslateInterface;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Translation\Model\Js\Config;

class DataProvider extends \Magento\Translation\Model\Js\DataProvider {

    protected StoreManagerInterface $storeManager;
    protected ConfigManager $configManager;
    private Logger $logger;

    public function __construct(\Magento\Framework\App\State                    $appState,
                                Config                                          $config,
                                \Magento\Framework\Filesystem\File\ReadFactory  $fileReadFactory,
                                \Magento\Framework\Phrase\RendererInterface     $translate,
                                \Magento\Framework\Component\ComponentRegistrar $componentRegistrar,
                                \Magento\Framework\Component\DirSearch          $dirSearch,
                                \Magento\Framework\View\Design\Theme\ThemePackageList $themePackageList,
                                StoreManagerInterface                           $storeManager,
                                ConfigManager                                   $configManager,
                                Logger                                          $logger,
                                ?\Magento\Framework\App\Utility\Files           $filesUtility = null)
    {
        parent::__construct($appState, $config, $fileReadFactory, $translate, $componentRegistrar, $dirSearch, $themePackageList, $filesUtility);
        $this->storeManager = $storeManager;
        $this->configManager = $configManager;
        $this->logger = $logger;
    }


    public function getData($themePath) {
        /**
         * This code is almost the same as the original, with the only difference being that we fill the dictionary with the original strings,
         * so that they can be translated by Clonable. We only do this for stores with the option enabled, otherwise we call the original
         * function.
         */
        $requestedLocale = $this->getRequestedLocale();
        $currentStore = $this->getStoreForLocale($requestedLocale);

        if ($currentStore != null && $this->configManager->isEnabledOverrideTranslationDictionary($currentStore)) {
            $areaCode = $this->appState->getAreaCode();

            $files = array_merge(
                $this->filesUtility->getJsFiles('base', $themePath),
                $this->filesUtility->getJsFiles($areaCode, $themePath),
                $this->filesUtility->getStaticHtmlFiles('base', $themePath),
                $this->filesUtility->getStaticHtmlFiles($areaCode, $themePath)
            );

            $dictionary = [];
            $dictionary['.CLONABLE_TRANSLATIONS_JS_OVERRIDDEN'] = 'YES';  // This helps Clonable detect that the translations.json was overridden by the plugin

            foreach ($files as $filePath) {
                $read = $this->fileReadFactory->create($filePath[0], \Magento\Framework\Filesystem\DriverPool::FILE);
                $content = $read->readAll();
                foreach ($this->getPhrases($content) as $phrase) {
                    try {
                        $dictionary[$phrase] = $phrase;
                    } catch (\Exception $e) {
                        throw new LocalizedException(
                            __('Error while translating phrase "%s" in file %s.', $phrase, $filePath[0]),
                            $e
                        );
                    }
                }
            }

            ksort($dictionary);

            return $dictionary;
        } else {
            return parent::getData($themePath);
        }
    }

    private function getStoreForLocale(?string $locale): ?int {
        if ($locale == null) {
            return null;
        }

        $allStores = $this->storeManager->getStores();
        foreach ($allStores as $store) {
            $storeLocale = $this->configManager->getLocale($store->getId());
            if ($storeLocale == $locale) {
                return $store->getId();
            }
        }

        return null;
    }

    private function getRequestedLocale(): ?string {
        if ($this->translate instanceof Composite) {
            // Accessing internal properties can cause weird errors, catch all Exceptions
            try {
                $renderers = (fn() => $this->_renderers)->call($this->translate);
                foreach ($renderers as $renderer) {
                    if ($renderer instanceof Translate) {
                        $translator = (fn() => $this->translator)->call($renderer);
                        if ($translator instanceof TranslateInterface) {
                            return $translator->getLocale();
                        }
                    }
                }
                $this->logger->error("Unable to determine locale while generating js-translations.json");
                return null;
            } catch (\Throwable $e) {
                $this->logger->error("Error determining locale: {$e->getMessage()}");
                return null;
            }
        } else {
            $this->logger->info("Translate is not a composite renderer");
            return null;
        }
    }
}
