<?php

namespace Clonable\Translator\Model\Queue\Consumer;

use Clonable\Translator\Api\ReportLogsRepositoryInterface;
use Clonable\Translator\Exception\ProductTranslationException;
use Clonable\Translator\Exception\TranslationUnavailableException;
use Clonable\Translator\Model\Logger\Logger;
use Clonable\Translator\Model\Product\ProductTranslator;
use Magento\Framework\MessageQueue\ConsumerConfigurationInterface;
use Clonable\Translator\Model\ReportLogsFactory;
use Magento\Framework\MessageQueue\EnvelopeInterface;
use Magento\Framework\MessageQueue\QueueInterface;
use Magento\Framework\Serialize\Serializer\Json;

class Product extends BaseConsumer
{
    private ProductTranslator $translatorProduct;

    public function __construct
    (
        ConsumerConfigurationInterface $configuration,
        ReportLogsRepositoryInterface  $reportLogsRepository,
        ReportLogsFactory $reportLogsFactory,
        ProductTranslator $translatorProduct,
        Json $json,
        Logger $logger
    ){
        parent::__construct($configuration, $reportLogsRepository, $reportLogsFactory, $json, $logger);
        $this->translatorProduct = $translatorProduct;
    }

    public function handleMessage(QueueInterface $queue, EnvelopeInterface $message)
    {
        try {
            $decoded = $this->json->unserialize($message->getBody());
            $this->translatorProduct->translate($decoded);
            $queue->acknowledge($message);
        } catch (ProductTranslationException $exception) {
            $queue->reject($message, $exception->shouldRequeue(), $exception->getMessage());
        } catch (TranslationUnavailableException $exception) {
            $queue->reject($message, true, $exception->getMessage());
            $this->reportLogsRepository->save($this->createReportLog("[ERROR] {$exception->getMessage()}, the consumer has been killed."));
            // Make sure to kill the current consumer process.
            // When the translator does not respond, there is no reason to try to translate the next item.
            exit();
        }
    }
}
