<?php

namespace Clonable\Translator\Model\Service;

use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\HTTP\Client\Curl;
use Clonable\Translator\Api\Service\ClonableValidateApiKeyInterface;
use Clonable\Translator\Model\ConfigManager;

class ClonableValidateApiKey implements ClonableValidateApiKeyInterface
{

    /**
     * @var Curl
     */
    private Curl $curl;

    /**
     * @param Curl $curl
     */
    public function __construct
    (
        Curl $curl
    ){
        $this->curl = $curl;
    }

    /**
     * @param $apiKey
     * @return bool
     */
    public function validateApiKey($apiKey): bool
    {
        $headers = [
            'Authorization' => 'Bearer ' . $apiKey,
            'Content-Type' => 'application/json',
            'accept' => 'application/json'
        ];
        $this->curl->setHeaders($headers);
        $this->curl->get(ConfigManager::API_URL . '/user');

        $status = $this->curl->getStatus();
        return $status === 200;
    }
}
