<?php

namespace Clonable\Translator\Observer;

use Clonable\Translator\Model\Product\Condition\ConditionChain;
use Clonable\Translator\Model\Service\Product\ProcessAssociatedProducts;
use Magento\Catalog\Api\Data\ProductInterface;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Exception\NoSuchEntityException;

class ProductAfterSaveObserver implements ObserverInterface {
    private ConditionChain $conditionChain;

    private ProcessAssociatedProducts $processAssociatedProducts;

    private ProductRepositoryInterface $productRepository;

    public function __construct
    (
        ConditionChain             $conditionChain,
        ProcessAssociatedProducts  $processAssociatedProducts,
        ProductRepositoryInterface $productRepository
    ) {
        $this->conditionChain = $conditionChain;
        $this->processAssociatedProducts = $processAssociatedProducts;
        $this->productRepository = $productRepository;
    }

    public function execute(Observer $observer): void {
        /** @var ProductInterface $product */
        $product = $observer->getProduct();
        foreach ($product->getStoreIds() as $storeId) {
            try {
                $productByStore = $this->productRepository->get($product->getSku(), false, $storeId, true);
                $this->conditionChain->process($productByStore);
                $this->processAssociatedProducts->processAssociatedProducts($productByStore);
            } catch (NoSuchEntityException $e) {
                continue;
            }
        }
    }
}
